<?php

/* -----------------------------------------------------------------
 * 	$Id: kauflux.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Kauflux {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Kauflux() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'selling';
        $this->v_module_name = 'Kauflux.de';
        $this->v_module_homepage = 'www.kauflux.de';
        $this->v_module_format = 'csv';
        $this->v_module_export_filename = 'kauflux.csv';
        $this->v_filename = 'kauflux.php';
        $this->v_keyname = 'KAUFLUX';
        $this->v_linkname = 'kauflux';
        $this->v_delimiter = '|';
        $this->v_enclosure = '';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, ',', '');
        $p_products_array['retail_price'] = number_format((double) $p_products_array['retail_price'], 2, ',', '');
        $p_products_array['products_shipping_costs'] = number_format((double) $p_products_array['products_shipping_costs'], 2, ',', '');
        $p_products_array['products_short_description'] = trim($p_products_array['products_short_description']);
        $p_products_array['products_description'] = trim($p_products_array['products_description']);
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_model'] = 'BestellNr';
        $t_csv_fields_array['products_id'] = 'Matchcode';
        $t_csv_fields_array['products_ean'] = 'EAN';
        $t_csv_fields_array['manufacturers_name'] = 'Hersteller';
        $t_csv_fields_array['products_shippingtime'] = 'Lieferzeit';
        $t_csv_fields_array['products_shipping_date'] = 'LieferbarAb';
        $t_csv_fields_array['products_name'] = 'Bezeichnung';
        $t_csv_fields_array['products_short_description'] = 'KurzText';
        $t_csv_fields_array['products_description'] = 'DetailText';
        $t_csv_fields_array['products_image_1'] = 'Bild1';
        $t_csv_fields_array['products_image_2'] = 'Bild2';
        $t_csv_fields_array['products_image_3'] = 'Bild3';
        $t_csv_fields_array['products_image_4'] = 'Bild4';
        $t_csv_fields_array['products_image_5'] = 'Bild5';
        $t_csv_fields_array['products_size'] = 'Abmessungen';
        $t_csv_fields_array['products_weight'] = 'Gewicht';
        $t_csv_fields_array['products_shipping_costs'] = 'VersandKlasse';
        $t_csv_fields_array['products_vpe_value'] = 'InhaltMenge';
        $t_csv_fields_array['products_vpe_name'] = 'InhaltEinheit';
        $t_csv_fields_array['products_vpe_compare'] = 'InhaltVergleich';
        $t_csv_fields_array['products_price'] = 'Preis';
        $t_csv_fields_array['products_tax'] = 'MwSt';
        $t_csv_fields_array['products_currency'] = 'W�hrung';
        $t_csv_fields_array['products_categories'] = 'Katalog1';
        $t_csv_fields_array['products_categories_last'] = 'Katalog2';
        $t_csv_fields_array['retail_price'] = 'SalesPrice';
        return($t_csv_fields_array);
    }

}

?>